﻿using Helper;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ZSMusic.IDAL;
using ZSMusic.Model;

namespace ZSMusic.DAL.Platforms
{//https://www.baidu.com/s?&wd=%E8%B8%8F%E5%B1%B1%E6%B2%B3%E5%8E%9F%E5%94%B1
    public class smart : IMusic
    {
        public List<Music> Search(string word, int page, int num)
        {
            if (page != 1)
            { throw new NotImplementedException("不支持加载更多"); }
            List<Music> list = new List<Music>();
            string src = "";
            for (int i = 0; i < 100; i++)
            {
                src = HttpHelper.Get("https://www.baidu.com/s?&wd=" + word);
                if (!src.Contains("百度安全验证"))
                { break; }
            }
            if (src.Contains("百度安全验证"))
            {
                throw new Exception("出现了百度安全验证,请发送错误报告");
            }
            string json = StringEx.Extract(src, "<div><!--s-data:(.*?)--><div>");
            if(string.IsNullOrWhiteSpace(json))
            { return list; }
            JArray array = JArray.Parse(JObject.Parse(json)["site"].ToString());
            foreach (var item in array)
            {
                JObject j = JObject.Parse(item.ToString());
                Music m = new Music();
                m.Id = j["musicId"].ToString();
                m.Name = j["songName"].ToString();
                m.Artist = j["allSingerName"].ToString();
                try
                {
                    m.Album = j["album"]["albumName"].ToString();
                }
                catch (Exception)
                { }
                switch (j["sitePinyin"].ToString())
                {
                    case "wangyi":
                        m.Source = "wy";
                        break;
                    case "qq":
                        m.Source = "qq";
                        break;
                    case "kugou":
                        m.Source = "kg";
                        break;
                    case "kuwo":
                        m.Source = "kw";
                        break;
                    default:
                        continue;
                }
                m.ToString();
                list.Add(m);
            }
            return list;
        }

        public List<Music> SearchCollection(string id)
        {
            throw new NotImplementedException();
        }

        public List<Music> SearchAlbum(string id)
        {
            throw new NotImplementedException();
        }

        public bool GetData(Music m, string type = "all")
        {
            throw new NotImplementedException();
        }
    }
}
